class TDM_SB extends DM_SB;

var bool bSetStart;
var float Speed, a, b;

var localized string MapTitle, Author, Restart, Continue, Ended, ElapsedTime, RemainingTime, FragGoal, TimeLimit;
var localized string PlayerString, FragsString, DeathsString, PingString;
var localized string TimeString, LossString, FPHString;
var color GreenColor, WhiteColor, GoldColor, BlueColor, LightCyanColor, SilverColor, BronzeColor, CyanColor, RedColor;
var PlayerReplicationInfo Ordered[32];
var float ScoreStart;	// top allowed score start
var bool bTimeDown;
var FontInfo MyFonts;
var localized string MapTitleQuote;

var texture RedTeamIcon, BlueTeamIcon, GreenTeamIcon, GoldTeamIcon;
var int Reds, Blues, Greens, Golds;


function Destroyed()
{
	Super.Destroyed();
	if ( MyFonts != None )
		MyFonts.Destroy();
}

function PostBeginPlay()
{
	Super.PostBeginPlay();
	MyFonts = FontInfo(spawn(Class<Actor>(DynamicLoadObject(class'ChallengeHUD'.default.FontInfoClass, class'Class'))));
}

function DrawHeader( canvas Canvas )
{
	local GameReplicationInfo GRI;
	local float XL, YL;

	Canvas.DrawColor = WhiteColor;
	GRI = PlayerPawn(Owner).GameReplicationInfo;

	Canvas.Font = MyFonts.GetHugeFont(Canvas.ClipX);

	Canvas.bCenter = True;

	if ( GRI.GameEndedComments != "" )
		{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, 0);
		Canvas.DrawText(GRI.GameEndedComments, True);
		}
	else
		{
		DrawVictoryConditions(Canvas);
		}
	Canvas.bCenter = False;
}

function DrawVictoryConditions(Canvas Canvas)
{
	local TournamentGameReplicationInfo TGRI;
	local float XL, YL;

	TGRI = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
	if ( TGRI == None )
		return;

	Canvas.SetPos(0, 0);
	Canvas.DrawText(TGRI.GameName);
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
	Canvas.SetPos(0, 32);

	if ( TGRI.FragLimit > 0 )
	{
		Canvas.DrawText(FragGoal@TGRI.FragLimit);
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, 54);
	}

	if ( TGRI.TimeLimit > 0 )
		Canvas.DrawText(TimeLimit@TGRI.TimeLimit$":00");
}

function string TwoDigitString(int Num)
{
	if ( Num < 10 )
		return "0"$Num;
	else
		return string(Num);
}

function DrawTrailer( canvas Canvas )
{
	local int Hours, Minutes, Seconds;
	local float XL, YL;
	local PlayerPawn PlayerOwner;

	Canvas.bCenter = true;
	Canvas.StrLen("Test", XL, YL);
	Canvas.DrawColor = WhiteColor;
	PlayerOwner = PlayerPawn(Owner);
	Canvas.SetPos(0, Canvas.ClipY - 2 * YL);
	if ( (Level.NetMode == NM_Standalone) && Level.Game.IsA('DeathMatchPlus') )
	{
		if ( DeathMatchPlus(Level.Game).bRatedGame )
			Canvas.DrawText(DeathMatchPlus(Level.Game).RatedGameLadderObj.SkillText@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
		else if ( DeathMatchPlus(Level.Game).bNoviceMode ) 
			Canvas.DrawText(class'ChallengeBotInfo'.default.Skills[Level.Game.Difficulty]@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
		else  
			Canvas.DrawText(class'ChallengeBotInfo'.default.Skills[Level.Game.Difficulty + 4]@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
	}
	else
		Canvas.DrawText(PlayerOwner.GameReplicationInfo.GameName@MapTitle@Level.Title, true);

	Canvas.SetPos(0, Canvas.ClipY - YL);
	if ( bTimeDown || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) )
	{
		bTimeDown = true;
		if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 0 )
			Canvas.DrawText(RemainingTime@"00:00", true);
		else
		{
			Minutes = PlayerOwner.GameReplicationInfo.RemainingTime/60;
			Seconds = PlayerOwner.GameReplicationInfo.RemainingTime % 60;
			Canvas.DrawText(RemainingTime@TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
		}
	}
	else
	{
		Seconds = PlayerOwner.GameReplicationInfo.ElapsedTime;
		Minutes = Seconds / 60;
		Hours   = Minutes / 60;
		Seconds = Seconds - (Minutes * 60);
		Minutes = Minutes - (Hours * 60);
		Canvas.DrawText(ElapsedTime@TwoDigitString(Hours)$":"$TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
	}

	if ( PlayerOwner.GameReplicationInfo.GameEndedComments != "" )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		if ( Level.NetMode == NM_Standalone )
			Canvas.DrawText(Ended@Continue, true);
		else
			Canvas.DrawText(Ended, true);
	}
	else if ( (PlayerOwner != None) && (PlayerOwner.Health <= 0) )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		Canvas.DrawText(Restart, true);
	}
	Canvas.bCenter = false;
}

function DrawRedPlayerStats(Canvas Canvas, PlayerReplicationInfo PRInfo, float XOffset, float YOffset, bool bCompressed)
{
local float XL, YL, XL2, YL2, XL3, YL3;
local Font CanvasFont;
local bool bLocalPlayer;
local PlayerPawn PlayerOwner;
local int Time;
local int Eff;
local String ImportTexture;
local Texture FLag;

	//Setup ScoreBox:
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor.R = 60;
	Canvas.DrawColor.G = 60;
	Canvas.DrawColor.B = 60;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 322, YOffset);
	Canvas.DrawTile(texture'FrameDot', 320, 1, 0, 0, 4, 4);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 322, YOffset + 30);
	Canvas.DrawTile(texture'FrameDot', 320, 1, 0, 0, 4, 4);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 322, YOffset + 1);
	Canvas.DrawTile(texture'FrameDot', 1, 30, 0, 0, 4, 4);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 3, YOffset + 1);
	Canvas.DrawTile(texture'FrameDot', 1, 30, 0, 0, 4, 4);
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor.R = 30;
	Canvas.DrawColor.G = 30;
	Canvas.DrawColor.B = 30;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 321, YOffset + 1);
	Canvas.DrawTile(texture'FrameDot', 318, 29, 0, 0, 4, 4);

	PlayerOwner = PlayerPawn(Owner);

	Canvas.DrawColor = WhiteColor;
	bLocalPlayer = (PRInfo.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName);
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.Style = ERenderStyle.STY_Normal;

	//Draw Country Flag:
	if ( PRInfo.bIsABot )
		{
		Canvas.SetPos(Canvas.ClipX * 0.5 - 321, YOffset + 1);
		Canvas.DrawTile(Texture'BotFlag', 44, 29, 0, 0, 48, 32);
		}
	else if ( PRI(PRInfo).Country != "" )
		{
		ImportTexture = "DanesHUD'n'SB_beta5.Flags."$PRI(PRInfo).Country;
		Flag = texture(DynamicLoadObject(ImportTexture, class'Texture'));
		Canvas.SetPos(Canvas.ClipX * 0.5 - 321, YOffset + 1);
		if ( Flag != None )
			Canvas.DrawTile(Flag, 44, 29, 0, 0, 48, 32);
		}
	else
		{
		Canvas.SetPos(Canvas.ClipX * 0.5 - 321, YOffset + 1);
		Canvas.DrawTile(Texture'NoFlag', 44, 29, 0, 0, 48, 32);
		}


	if ( bLocalPlayer ) 
		Canvas.DrawColor = GoldColor;
	else 
		Canvas.DrawColor = RedColor;

	Canvas.SetPos(Canvas.ClipX * 0.5 - 274, YOffset + 1);
	Canvas.DrawText(PRInfo.PlayerName, False);
	XL2 = Canvas.CurX;

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 90, YOffset );
	Canvas.DrawTile(texture'Icon_Skull', 16, 16, 0, 0, 128, 128);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 40, YOffset );
	Canvas.DrawTile(texture'tombstone', 16, 16, 0, 0, 128, 128);

	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos( Canvas.ClipX * 0.5 - 74, YOffset + 2 );
	Canvas.DrawText( int(PRInfo.Score), false );

	Canvas.SetPos( Canvas.ClipX * 0.5 - 24, YOffset + 2 );
	Canvas.DrawText( int(PRInfo.Deaths), false );


	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetAReallySmallFont(1920);//Canvas.ClipX
	Canvas.StrLen("TEST", XL, YL);
	YL -= 4;

	// Draw Ping
	if ( !PRInfo.bIsABot )
		{
		Canvas.SetPos( Canvas.ClipX * 0.5 - 274, YOffset + 2*YL );
		Canvas.DrawText("Headshots:"@PRI(PRInfo).Headshots$", Telefrags:"@PRI(PRInfo).Telefrags$", Suicides:"@PRI(PRInfo).Suicides, false );
		Canvas.StrLen(PingString$":"@PRInfo.Ping, XL, YL2);
		Canvas.SetPos( Canvas.ClipX * 0.5 - XL - 3, YOffset + 2*YL );
		Canvas.DrawText( PingString$":"@PRInfo.Ping, false );
		}

	// Draw EFF
	if ( PRInfo.Score < 0 )
		Eff = 0;
	else
		Eff = PRInfo.Score / (PRInfo.Score + PRInfo.Deaths) * 100;
	Canvas.SetPos( XL2 , YOffset + 2 );
	Canvas.DrawText( "EFF: "@Eff$"%", false );
}

function DrawBluePlayerStats(Canvas Canvas, PlayerReplicationInfo PRInfo, float XOffset, float YOffset, bool bCompressed)
{
local float XL, YL, XL2, YL2, XL3, YL3;
local Font CanvasFont;
local bool bLocalPlayer;
local PlayerPawn PlayerOwner;
local int Time;
local int Eff;
local String ImportTexture;
local Texture FLag;

	//Setup ScoreBox:
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor.R = 60;
	Canvas.DrawColor.G = 60;
	Canvas.DrawColor.B = 60;
	Canvas.SetPos(Canvas.ClipX * 0.5 + 2, YOffset);
	Canvas.DrawTile(texture'FrameDot', 320, 1, 0, 0, 4, 4);
	Canvas.SetPos(Canvas.ClipX * 0.5 + 2, YOffset + 30);
	Canvas.DrawTile(texture'FrameDot', 320, 1, 0, 0, 4, 4);
	Canvas.SetPos(Canvas.ClipX * 0.5 + 2, YOffset + 1);
	Canvas.DrawTile(texture'FrameDot', 1, 30, 0, 0, 4, 4);
	Canvas.SetPos(Canvas.ClipX * 0.5 + 322, YOffset );
	Canvas.DrawTile(texture'FrameDot', 1, 31, 0, 0, 4, 4);
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor.R = 30;
	Canvas.DrawColor.G = 30;
	Canvas.DrawColor.B = 30;
	Canvas.SetPos(Canvas.ClipX * 0.5 + 3, YOffset + 1);
	Canvas.DrawTile(texture'FrameDot', 319, 29, 0, 0, 4, 4);

	PlayerOwner = PlayerPawn(Owner);

	Canvas.DrawColor = WhiteColor;
	bLocalPlayer = (PRInfo.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName);
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.Style = ERenderStyle.STY_Normal;

	//Draw Country Flag:
	if ( PRInfo.bIsABot )
		{
		Canvas.SetPos(Canvas.ClipX * 0.5 + 3, YOffset + 1);
		Canvas.DrawTile(Texture'BotFlag', 44, 29, 0, 0, 48, 32);
		}
	else if ( PRI(PRInfo).Country != "" )
		{
		ImportTexture = "DanesHUD'n'SB_beta5.Flags."$PRI(PRInfo).Country;
		Flag = texture(DynamicLoadObject(ImportTexture, class'Texture'));
		Canvas.SetPos(Canvas.ClipX * 0.5 + 3, YOffset + 1);
		if ( Flag != None )
			Canvas.DrawTile(Flag, 44, 29, 0, 0, 48, 32);
		}
	else
		{
		Canvas.SetPos(Canvas.ClipX * 0.5 + 3, YOffset + 1);
		Canvas.DrawTile(Texture'NoFlag', 44, 29, 0, 0, 48, 32);
		}


	if ( bLocalPlayer ) 
		Canvas.DrawColor = GoldColor;
	else 
		Canvas.DrawColor = BlueColor;

	Canvas.SetPos(Canvas.ClipX * 0.5 + 48, YOffset + 1);
	Canvas.DrawText(PRInfo.PlayerName, False);
	XL2 = Canvas.CurX;

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(Canvas.ClipX * 0.5 + 240, YOffset );
	Canvas.DrawTile(texture'Icon_Skull', 16, 16, 0, 0, 128, 128);
	Canvas.SetPos(Canvas.ClipX * 0.5 + 290, YOffset );
	Canvas.DrawTile(texture'tombstone', 16, 16, 0, 0, 128, 128);

	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos( Canvas.ClipX * 0.5 + 256, YOffset + 2 );
	Canvas.DrawText( int(PRInfo.Score), false );

	Canvas.SetPos( Canvas.ClipX * 0.5 + 306, YOffset + 2 );
	Canvas.DrawText( int(PRInfo.Deaths), false );


	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetAReallySmallFont(1920);//Canvas.ClipX
	Canvas.StrLen("TEST", XL, YL);
	YL -= 4;

	// Draw Ping
	if ( !PRInfo.bIsABot )
		{
		Canvas.SetPos( Canvas.ClipX * 0.5 + 48, YOffset + 2*YL );
		Canvas.DrawText("Headshots:"@PRI(PRInfo).Headshots$", Telefrags:"@PRI(PRInfo).Telefrags$", Suicides:"@PRI(PRInfo).Suicides, false );
		Canvas.StrLen(PingString$":"@PRInfo.Ping, XL, YL2);
		Canvas.SetPos( Canvas.ClipX * 0.5 - XL + 320, YOffset + 2*YL );
		Canvas.DrawText( PingString$":"@PRInfo.Ping, false );
		}

	// Draw EFF
	if ( PRInfo.Score < 0 )
		Eff = 0;
	else
		Eff = PRInfo.Score / (PRInfo.Score + PRInfo.Deaths) * 100;
	Canvas.SetPos( XL2 , YOffset + 2 );
	Canvas.DrawText( "EFF: "@Eff$"%", false );
}

function DrawGreenPlayerStats(Canvas Canvas, PlayerReplicationInfo PRInfo, float XOffset, float YOffset, bool bCompressed)
{
local float XL, YL, XL2, YL2, XL3, YL3;
local Font CanvasFont;
local bool bLocalPlayer;
local PlayerPawn PlayerOwner;
local int Time;
local int Eff;
local String ImportTexture;
local Texture FLag;

	//Setup ScoreBox:
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor.R = 60;
	Canvas.DrawColor.G = 60;
	Canvas.DrawColor.B = 60;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 322, YOffset);
	Canvas.DrawTile(texture'FrameDot', 320, 1, 0, 0, 4, 4);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 322, YOffset + 30);
	Canvas.DrawTile(texture'FrameDot', 320, 1, 0, 0, 4, 4);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 322, YOffset + 1);
	Canvas.DrawTile(texture'FrameDot', 1, 30, 0, 0, 4, 4);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 3, YOffset + 1);
	Canvas.DrawTile(texture'FrameDot', 1, 30, 0, 0, 4, 4);
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor.R = 30;
	Canvas.DrawColor.G = 30;
	Canvas.DrawColor.B = 30;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 321, YOffset + 1);
	Canvas.DrawTile(texture'FrameDot', 318, 29, 0, 0, 4, 4);

	PlayerOwner = PlayerPawn(Owner);

	Canvas.DrawColor = WhiteColor;
	bLocalPlayer = (PRInfo.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName);
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.Style = ERenderStyle.STY_Normal;

	//Draw Country Flag:
	if ( PRInfo.bIsABot )
		{
		Canvas.SetPos(Canvas.ClipX * 0.5 - 321, YOffset + 1);
		Canvas.DrawTile(Texture'BotFlag', 44, 29, 0, 0, 48, 32);
		}
	else if ( PRI(PRInfo).Country != "" )
		{
		ImportTexture = "DanesHUD'n'SB_beta5.Flags."$PRI(PRInfo).Country;
		Flag = texture(DynamicLoadObject(ImportTexture, class'Texture'));
		Canvas.SetPos(Canvas.ClipX * 0.5 - 321, YOffset + 1);
		if ( Flag != None )
			Canvas.DrawTile(Flag, 44, 29, 0, 0, 48, 32);
		}
	else
		{
		Canvas.SetPos(Canvas.ClipX * 0.5 - 321, YOffset + 1);
		Canvas.DrawTile(Texture'NoFlag', 44, 29, 0, 0, 48, 32);
		}


	if ( bLocalPlayer ) 
		Canvas.DrawColor = GoldColor;
	else 
		Canvas.DrawColor = GreenColor;

	Canvas.SetPos(Canvas.ClipX * 0.5 - 274, YOffset + 1);
	Canvas.DrawText(PRInfo.PlayerName, False);
	XL2 = Canvas.CurX;

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 90, YOffset );
	Canvas.DrawTile(texture'Icon_Skull', 16, 16, 0, 0, 128, 128);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 40, YOffset );
	Canvas.DrawTile(texture'tombstone', 16, 16, 0, 0, 128, 128);

	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos( Canvas.ClipX * 0.5 - 74, YOffset + 2 );
	Canvas.DrawText( int(PRInfo.Score), false );

	Canvas.SetPos( Canvas.ClipX * 0.5 - 24, YOffset + 2 );
	Canvas.DrawText( int(PRInfo.Deaths), false );


	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetAReallySmallFont(1920);//Canvas.ClipX
	Canvas.StrLen("TEST", XL, YL);
	YL -= 4;

	// Draw Ping
	if ( !PRInfo.bIsABot )
		{
		Canvas.SetPos( Canvas.ClipX * 0.5 - 274, YOffset + 2*YL );
		Canvas.DrawText("Headshots:"@PRI(PRInfo).Headshots$", Telefrags:"@PRI(PRInfo).Telefrags$", Suicides:"@PRI(PRInfo).Suicides, false );
		Canvas.StrLen(PingString$":"@PRInfo.Ping, XL, YL2);
		Canvas.SetPos( Canvas.ClipX * 0.5 - XL - 3, YOffset + 2*YL );
		Canvas.DrawText( PingString$":"@PRInfo.Ping, false );
		}

	// Draw EFF
	if ( PRInfo.Score < 0 )
		Eff = 0;
	else
		Eff = PRInfo.Score / (PRInfo.Score + PRInfo.Deaths) * 100;
	Canvas.SetPos( XL2 , YOffset + 2 );
	Canvas.DrawText( "EFF: "@Eff$"%", false );
}

function DrawGoldPlayerStats(Canvas Canvas, PlayerReplicationInfo PRInfo, float XOffset, float YOffset, bool bCompressed)
{
local float XL, YL, XL2, YL2, XL3, YL3;
local Font CanvasFont;
local bool bLocalPlayer;
local PlayerPawn PlayerOwner;
local int Time;
local int Eff;
local String ImportTexture;
local Texture FLag;

	//Setup ScoreBox:
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor.R = 60;
	Canvas.DrawColor.G = 60;
	Canvas.DrawColor.B = 60;
	Canvas.SetPos(Canvas.ClipX * 0.5 + 2, YOffset);
	Canvas.DrawTile(texture'FrameDot', 320, 1, 0, 0, 4, 4);
	Canvas.SetPos(Canvas.ClipX * 0.5 + 2, YOffset + 30);
	Canvas.DrawTile(texture'FrameDot', 320, 1, 0, 0, 4, 4);
	Canvas.SetPos(Canvas.ClipX * 0.5 + 2, YOffset + 1);
	Canvas.DrawTile(texture'FrameDot', 1, 30, 0, 0, 4, 4);
	Canvas.SetPos(Canvas.ClipX * 0.5 + 322, YOffset );
	Canvas.DrawTile(texture'FrameDot', 1, 31, 0, 0, 4, 4);
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor.R = 30;
	Canvas.DrawColor.G = 30;
	Canvas.DrawColor.B = 30;
	Canvas.SetPos(Canvas.ClipX * 0.5 + 3, YOffset + 1);
	Canvas.DrawTile(texture'FrameDot', 319, 29, 0, 0, 4, 4);

	PlayerOwner = PlayerPawn(Owner);

	Canvas.DrawColor = WhiteColor;
	bLocalPlayer = (PRInfo.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName);
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.Style = ERenderStyle.STY_Normal;

	//Draw Country Flag:
	if ( PRInfo.bIsABot )
		{
		Canvas.SetPos(Canvas.ClipX * 0.5 + 3, YOffset + 1);
		Canvas.DrawTile(Texture'BotFlag', 44, 29, 0, 0, 48, 32);
		}
	else if ( PRI(PRInfo).Country != "" )
		{
		ImportTexture = "DanesHUD'n'SB_beta5.Flags."$PRI(PRInfo).Country;
		Flag = texture(DynamicLoadObject(ImportTexture, class'Texture'));
		Canvas.SetPos(Canvas.ClipX * 0.5 + 3, YOffset + 1);
		if ( Flag != None )
			Canvas.DrawTile(Flag, 44, 29, 0, 0, 48, 32);
		}
	else
		{
		Canvas.SetPos(Canvas.ClipX * 0.5 + 3, YOffset + 1);
		Canvas.DrawTile(Texture'NoFlag', 44, 29, 0, 0, 48, 32);
		}


	if ( bLocalPlayer ) 
		Canvas.DrawColor = WhiteColor;
	else 
		Canvas.DrawColor = GoldColor;

	Canvas.SetPos(Canvas.ClipX * 0.5 + 48, YOffset + 1);
	Canvas.DrawText(PRInfo.PlayerName, False);
	XL2 = Canvas.CurX;

	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(Canvas.ClipX * 0.5 + 240, YOffset );
	Canvas.DrawTile(texture'Icon_Skull', 16, 16, 0, 0, 128, 128);
	Canvas.SetPos(Canvas.ClipX * 0.5 + 290, YOffset );
	Canvas.DrawTile(texture'tombstone', 16, 16, 0, 0, 128, 128);

	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos( Canvas.ClipX * 0.5 + 256, YOffset + 2 );
	Canvas.DrawText( int(PRInfo.Score), false );

	Canvas.SetPos( Canvas.ClipX * 0.5 + 306, YOffset + 2 );
	Canvas.DrawText( int(PRInfo.Deaths), false );


	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetAReallySmallFont(1920);//Canvas.ClipX
	Canvas.StrLen("TEST", XL, YL);
	YL -= 4;

	// Draw Ping
	if ( !PRInfo.bIsABot )
		{
		Canvas.SetPos( Canvas.ClipX * 0.5 + 48, YOffset + 2*YL );
		Canvas.DrawText("Headshots:"@PRI(PRInfo).Headshots$", Telefrags:"@PRI(PRInfo).Telefrags$", Suicides:"@PRI(PRInfo).Suicides, false );
		Canvas.StrLen(PingString$":"@PRInfo.Ping, XL, YL2);
		Canvas.SetPos( Canvas.ClipX * 0.5 - XL + 320, YOffset + 2*YL );
		Canvas.DrawText( PingString$":"@PRInfo.Ping, false );
		}

	// Draw EFF
	if ( PRInfo.Score < 0 )
		Eff = 0;
	else
		Eff = PRInfo.Score / (PRInfo.Score + PRInfo.Deaths) * 100;
	Canvas.SetPos( XL2 , YOffset + 2 );
	Canvas.DrawText( "EFF: "@Eff$"%", false );
}

function SortScores(int N)
{
	local int I, J, Max;
	local PlayerReplicationInfo TempPRI;
	
	for ( I=0; I<N-1; I++ )
	{
		Max = I;
		for ( J=I+1; J<N; J++ )
		{
			if ( Ordered[J].Score > Ordered[Max].Score )
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths < Ordered[Max].Deaths))
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths == Ordered[Max].Deaths) &&
					 (Ordered[J].PlayerID < Ordered[Max].Score))
				Max = J;
		}

		TempPRI = Ordered[Max];
		Ordered[Max] = Ordered[I];
		Ordered[I] = TempPRI;
	}
}

simulated function Tick(float DeltaTime)
{
	Super.Tick(DeltaTime);

	a -= Speed;
	if ( a < 0 )
		{
		a = 6.283185307;
		}
	b -= Speed;
	if ( b < 0 )
		{
		b = 6.283185307;
		}
}

function ShowScores( canvas Canvas )
{
local PlayerReplicationInfo PRI;
local int PlayerCount, i;
local float XL, YL, Scale;
local float RedYOffset, BlueYOffset, GreenYOffset, GoldYOffset, YStart;
local int Teams, RedScore, BlueScore, GreenScore, GoldScore;

	Canvas.Style = ERenderStyle.STY_Normal;

	// Wipe everything.
	for ( i=0; i<ArrayCount(Ordered); i++ )
		Ordered[i] = None;
	for ( i=0; i<32; i++ )
	{
		if (PlayerPawn(Owner).GameReplicationInfo.PRIArray[i] != None)
		{
			PRI = PlayerPawn(Owner).GameReplicationInfo.PRIArray[i];
			if ( !PRI.bIsSpectator || PRI.bWaitingPlayer )
			{
				Ordered[PlayerCount] = PRI;
				PlayerCount++;
				if ( PlayerCount == ArrayCount(Ordered) )
					break;
			}
		}
	}
	SortScores(PlayerCount);
	DrawHeader(Canvas);

	if ( Reds > 0 )
		Teams++;
	if ( Blues > 0 )
		Teams++;
	if ( Greens > 0 )
		Teams++;
	if ( Golds > 0 )
		Teams++;

	Reds = 0;
	Blues = 0;
	Greens = 0;
	Golds = 0;

	RedYOffset = 86;
	BlueYOffset = 86;
	GreenYOffset = Canvas.ClipY * 0.5;
	GoldYOffset = Canvas.ClipY * 0.5;

	for ( I=0; I<PlayerCount; I++ )
		{
		if ( Ordered[I].Team == 0 )
			{
			if ( RedYOffset < Canvas.ClipY * 0.5 - 32 || Teams < 3)
			DrawRedPlayerStats( Canvas, Ordered[I], 0, RedYOffset, false );
			RedYOffset += 32;
			Reds++;
			RedScore += Ordered[I].Score;
			}
		else if ( Ordered[I].Team == 1 )
			{
			if ( BlueYOffset < Canvas.ClipY * 0.5 - 32 || Teams < 4)
			DrawBluePlayerStats( Canvas, Ordered[I], 0, BlueYOffset, false );
			BlueYOffset += 32;
			Blues++;
			BlueScore += Ordered[I].Score;
			}
		else if ( Ordered[I].Team == 2 )
			{
			if ( GreenYOffset < Canvas.ClipY - 70 )
			DrawGreenPlayerStats( Canvas, Ordered[I], 0, GreenYOffset, false );
			GreenYOffset += 32;
			Greens++;
			GreenScore += Ordered[I].Score;
			}
		else
			{
			if ( GoldYOffset < Canvas.ClipY - 70 )
			DrawGoldPlayerStats( Canvas, Ordered[I], 0, GoldYOffset, false );
			GoldYOffset += 32;
			Golds++;
			GoldScore += Ordered[I].Score;
			}
		}
	if ( Reds > 0 )
		{
		Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
		Canvas.Style = ERenderStyle.STY_Masked;
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 396, 86);

		if ( PRI(PlayerPawn(Owner).PlayerReplicationInfo).RedTeamIcon != "" )
			{
			RedTeamIcon = texture(DynamicLoadObject(PRI(PlayerPawn(Owner).PlayerReplicationInfo).RedTeamIcon, class'Texture'));
			Canvas.DrawTile(RedTeamIcon, 64, 64, 0, 0, 64, 64);
			}
		else
			Canvas.DrawTile(texture'I_TeamR', 64, 64, 0, 0, 64, 64);
	
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.StrLen(RedScore, XL, YL);
		Canvas.SetPos(Canvas.ClipX * 0.5 - 364 - 0.5 * XL, 150);
		Canvas.DrawColor = RedColor;
		Canvas.DrawText(RedScore, true);
		}
	if ( Blues > 0 )
		{
		Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
		Canvas.Style = ERenderStyle.STY_Masked;
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Canvas.ClipX * 0.5 + 332, 86);

		if ( PRI(PlayerPawn(Owner).PlayerReplicationInfo).BlueTeamIcon != "" )
			{
			BlueTeamIcon = texture(DynamicLoadObject(PRI(PlayerPawn(Owner).PlayerReplicationInfo).BlueTeamIcon, class'Texture'));
			Canvas.DrawTile(BlueTeamIcon, 64, 64, 0, 0, 64, 64);
			}
		else
			Canvas.DrawTile(texture'I_TeamB', 64, 64, 0, 0, 64, 64);
	
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.StrLen(BlueScore, XL, YL);
		Canvas.SetPos(Canvas.ClipX * 0.5 + 364 - 0.5 * XL, 150);
		Canvas.DrawColor = BlueColor;
		Canvas.DrawText(BlueScore, true);
		}
	if ( Greens > 0 )
		{
		Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
		Canvas.Style = ERenderStyle.STY_Masked;
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 396, Canvas.ClipY * 0.5);

		if ( PRI(PlayerPawn(Owner).PlayerReplicationInfo).GreenTeamIcon != "" )
			{
			GreenTeamIcon = texture(DynamicLoadObject(PRI(PlayerPawn(Owner).PlayerReplicationInfo).GreenTeamIcon, class'Texture'));
			Canvas.DrawTile(GreenTeamIcon, 64, 64, 0, 0, 64, 64);
			}
		else
			Canvas.DrawTile(texture'I_TeamG', 64, 64, 0, 0, 64, 64);
	
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.StrLen(GreenScore, XL, YL);
		Canvas.SetPos(Canvas.ClipX * 0.5 - 364 - 0.5 * XL, Canvas.ClipY * 0.5 + 64);
		Canvas.DrawColor = GreenColor;
		Canvas.DrawText(GreenScore, true);
		}
	if ( Golds > 0 )
		{
		Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
		Canvas.Style = ERenderStyle.STY_Masked;
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Canvas.ClipX * 0.5 + 332, Canvas.ClipY * 0.5);

		if ( PRI(PlayerPawn(Owner).PlayerReplicationInfo).BlueTeamIcon != "" )
			{
			GoldTeamIcon = texture(DynamicLoadObject(PRI(PlayerPawn(Owner).PlayerReplicationInfo).GoldTeamIcon, class'Texture'));
			Canvas.DrawTile(GoldTeamIcon, 64, 64, 0, 0, 64, 64);
			}
		else
			Canvas.DrawTile(texture'I_TeamY', 64, 64, 0, 0, 64, 64);
	
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.StrLen(GoldScore, XL, YL);
		Canvas.SetPos(Canvas.ClipX * 0.5 + 364 - 0.5 * XL, Canvas.ClipY * 0.5 + 64);
		Canvas.DrawColor = GoldColor;
		Canvas.DrawText(GoldScore, true);
		}

	Canvas.DrawColor = WhiteColor;

	// Trailer
	if ( !Level.bLowRes )
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		DrawTrailer(Canvas);
	}
	Canvas.DrawColor = WhiteColor;

}

defaultproperties
{
     MapTitle="in"
     Author="by"
     Restart="You are dead.  Hit [Fire] to respawn!"
     Continue=" Hit [Fire] to continue!"
     Ended="The match has ended."
     ElapsedTime="Elapsed Time: "
     RemainingTime="Remaining Time: "
     FragGoal="Frag Limit:"
     TimeLimit="Time Limit:"
     PlayerString="Player"
     FragsString="Frags"
     DeathsString="Deaths"
     PingString="Ping"
     TimeString="Time"
     LossString="Loss"
     FPHString="FPH"
     GreenColor=(G=255)
     WhiteColor=(R=255,G=255,B=255)
     GoldColor=(R=255,G=255)
     BlueColor=(B=255)
     LightCyanColor=(R=128,G=255,B=255)
     SilverColor=(R=138,G=164,B=166)
     BronzeColor=(R=203,G=147,B=52)
     CyanColor=(G=128,B=255)
     RedColor=(R=255)
     bSetStart=False
}
